import { SFNClient, StartExecutionCommand } from "@aws-sdk/client-sfn";
// @ts-ignore
import { env } from '$amplify/env/trigger-publish-preview-to-live';
import { Schema } from '../resource';
import { Context } from 'aws-lambda';

const INVALID_CHARACTERS_REGEX = /[?*<>{}"#%\\^|~`$&,;:/.]/g

export const handler: Schema["triggerPublishPreviewToLive"]["functionHandler"] = async (event, context) => {
  const input = {};
  const stateMachineArn = env.BACKEND_AWS_PUBLISH_CHANGES_STEP_FUNCTION_ARN;

  const name = getName(context)
  const safeName = name.replace(INVALID_CHARACTERS_REGEX, "_");

  const request = {
    stateMachineArn,
    name: safeName,
    input: JSON.stringify(input)
  };

  try {
    const response = await startExecution(request);
    console.log(response);
    return {
      ...response,
      executionName: safeName,
    };
  } catch (error) {
    console.error(error);
    if (typeof error === 'string' || error instanceof Error) {
      return error;
    }

    return "Unknown error occured"
  }
};

function getName(context: Context) {
  const now = new Date().toISOString().slice(0, 19);
  const idenity = context.identity ? context.identity.cognitoIdentityId.slice(0, 10) : undefined
  const app = context.clientContext ? context.clientContext.client.appTitle.slice(0, 10).replace('-', '') : undefined
  const f = context.functionName.slice(0, 10);
  const prefix = "ManualTrigger"

  if (app && idenity) {
    return `${prefix}-${now}-${f}-${idenity}-${app}`
  }

  if (app) {
    return `${prefix}-${now}-${f}-${app}`
  }

  if (idenity) {
    return `${prefix}-${now}-${f}-${idenity}`
  }

  return `${prefix}-${now}-${f}`
}

export const startExecution = async (request: { stateMachineArn: string; name: string; input: string }) => {
  const client = new SFNClient({});
  const command = new StartExecutionCommand(request);
  return client.send(command);
};

